/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jclass.bwt.BWTUtil;
import jclass.bwt.ComboBoxConverter;
import jclass.bwt.ComboDialog;
import jclass.bwt.ComboField;
import jclass.bwt.ComboList;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCArrowButton;
import jclass.bwt.JCComboBoxEvent;
import jclass.bwt.JCComboBoxListener;
import jclass.bwt.JCComponent;
import jclass.bwt.JCContainer;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCItemSelectable;
import jclass.bwt.JCList;
import jclass.bwt.JCListEvent;
import jclass.bwt.JCListListener;
import jclass.bwt.JCTextField;
import jclass.bwt.Shadow;
import jclass.util.JCEnvironment;
import jclass.util.JCVector;

public class JCComboBox
extends JCContainer
implements KeyListener,
JCListListener,
JCActionListener,
JCItemSelectable {
    public static final int COMBOBOX_SIMPLE = 0;
    public static final int COMBOBOX_DROPDOWN = 1;
    public static final int COMBOBOX_DROPDOWN_LIST = 2;
    ComboField text;
    ComboList list;
    JCArrowButton button;
    int style = 1;
    protected boolean list_poppedup = false;
    boolean using_window = false;
    transient Window list_window;
    protected JCVector itemListeners = new JCVector(0);
    protected JCVector actionListeners = new JCVector(0);
    protected JCVector listeners = new JCVector(0);
    private static final String base = "combobox";
    private static int nameCounter;
    protected static final int BEGIN = 0;
    protected static final int END = 1;

    public JCComboBox() {
        this((String[])null, (String)null);
    }

    public JCComboBox(JCVector jCVector) {
        this(jCVector, null, null);
    }

    public JCComboBox(String[] stringArray, String string) {
        this(new JCVector(stringArray), null, string);
    }

    public JCComboBox(JCVector jCVector, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.setLayout(null);
        this.text = new ComboField(this);
        this.text.addActionListener(this);
        this.list = new ComboList(this);
        this.list.setAutoSelect(true);
        this.list.setVisibleRows(5);
        this.button = new JCArrowButton(9);
        this.button.shadow = 2;
        this.button.right_border_color = Color.black;
        this.button.addActionListener(this);
        this.list.setItems(jCVector);
        this.list.addActionListener(this);
        this.list.addItemListener(this);
        this.setStyle(this.style);
        this.text.addKeyListener(this);
    }

    protected void getParameters() {
        super.getParameters();
        ComboBoxConverter.getParams(this);
    }

    public JCTextField getTextField() {
        return this.text;
    }

    public JCList getList() {
        return this.list;
    }

    public JCArrowButton getButton() {
        return this.button;
    }

    public synchronized void setText(String string) {
        this.text.setText(string);
    }

    public synchronized String getText() {
        return this.text.getText();
    }

    public synchronized void setItems(String[] stringArray) {
        this.list.setItems(stringArray);
    }

    public synchronized String[] getItems() {
        return this.list.getItemsStrings();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        ComboBoxConverter.checkStyle(n);
        this.style = n;
        this.text.setEditable(this.style != 2);
        this.text.setShowCursorPosition(this.style != 2);
        if (this.style == 0) {
            this.setInsets(new Insets(0, 0, 0, 0));
            this.text.shadow = 2;
        } else {
            this.setInsets(new Insets(2, 2, 2, 2));
            this.text.shadow = 0;
        }
        this.updateParent();
    }

    public int getItemCount() {
        return this.list.countItems();
    }

    public Object getItem(int n) {
        return this.list.getItem(n);
    }

    public synchronized void add(String string) {
        this.list.addItem(string);
    }

    public synchronized void remove(String string) {
        this.list.remove(string);
    }

    public synchronized void removeAll() {
        this.list.clear();
    }

    public synchronized String getSelectedItem() {
        Object object = this.list.getSelectedItem();
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public synchronized void select(int n) {
        this.list.select(n);
    }

    public synchronized void select(Object object) {
        this.list.select(object);
    }

    public synchronized Object[] getSelectedObjects() {
        return this.list.getSelectedObjects();
    }

    public synchronized int[] getSelectedIndexes() {
        return this.list.getSelectedIndexes();
    }

    public void setVisibleRows(int n) {
        this.list.setVisibleRows(n);
    }

    public void addComboBoxListener(JCComboBoxListener jCComboBoxListener) {
        this.listeners.add(jCComboBoxListener);
    }

    public void removeComboBoxListener(JCComboBoxListener jCComboBoxListener) {
        this.listeners.removeElement(jCComboBoxListener);
    }

    public void addActionListener(JCActionListener jCActionListener) {
        this.actionListeners.add(jCActionListener);
    }

    public void removeActionListener(JCActionListener jCActionListener) {
        this.actionListeners.removeElement(jCActionListener);
    }

    public void addItemListener(JCItemListener jCItemListener) {
        this.itemListeners.add(jCItemListener);
    }

    public void removeItemListener(JCItemListener jCItemListener) {
        this.itemListeners.removeElement(jCItemListener);
    }

    protected int preferredWidth() {
        int n = this.text.preferredSize().width + this.button.preferredSize().width;
        if (this.style != 0) {
            return n;
        }
        return Math.max(n, this.list.preferredSize().width);
    }

    protected int preferredHeight() {
        int n = this.text.preferredSize().height;
        if (this.style != 0) {
            return Math.max(n, this.button.preferredSize().height);
        }
        return n + this.list.preferredSize().height;
    }

    public void addNotify() {
        this.add(this.text);
        this.add(this.button);
        if (this.style == 0) {
            this.add(this.list);
        }
        super.addNotify();
    }

    public synchronized void layout() {
        int n;
        int n2 = this.button.preferredSize().width;
        int n3 = n = this.text.preferredSize().height;
        int n4 = this.insets().left + this.insets().right;
        int n5 = this.insets().top + this.insets().bottom;
        int n6 = Math.max(0, this.size().width - n4);
        int n7 = Math.max(0, this.size().height - n5);
        if (this.style == 0) {
            n3 = 0;
            n2 = 0;
            this.remove(this.button);
            int n8 = Math.max(n6, this.list.preferredSize().width);
            int n9 = Math.min(n7 - n, this.list.preferredSize().height);
            int n10 = Math.min(0, n8 - n6);
            this.list.reshape(n10 + this.insets().left, n + this.insets().top, n8, n9);
            this.add(this.list);
            this.text.reshape(this.insets().left, this.insets().top, n6 - n2, n);
            return;
        }
        this.remove(this.list);
        int n11 = Math.min(n7, n + 1);
        this.button.reshape(this.size().width - n2 - this.insets().right, this.insets().top, n2, n11 + 1);
        this.text.reshape(this.insets().left, this.insets().top, n6 - n2, n11 + 1);
    }

    public void showListAction(JCActionEvent jCActionEvent) {
        if (this.style == 0) {
            return;
        }
        if (this.list_poppedup) {
            return;
        }
        this.postComboBoxEvent(0, null);
        int n = this.list.find(this.text.getText());
        if (n >= 0) {
            this.list.select(n, false);
        } else {
            this.list.deselectAll();
        }
        Frame frame = this.text.getFrame();
        this.using_window = JCEnvironment.getAppletContext(this.applet) == null ? true : (JCEnvironment.getBrowser(this) == 4 ? true : JCEnvironment.getBrowser(this) == 2);
        if (!this.using_window) {
            if (JCEnvironment.getJavaVersion() < 110) {
                frame.add(this.list);
            } else {
                frame.add((Component)this.list, 0);
            }
            this.list.addNotify();
        } else if (this.list_window == null) {
            this.list_window = JCEnvironment.getOS() == 1 ? new ComboDialog(this, frame) : new Window(frame);
            this.list_window.add("Center", this.list);
            this.list_window.pack();
        }
        if (!this.list.bg_set) {
            this.list.setBackground(this.text.getBackground());
            this.list.bg_set = false;
        }
        int n2 = Math.max(this.size().width, this.list.preferredSize().width);
        int n3 = this.list.preferredSize().height;
        int n4 = Math.min(0, n2 - this.size().width);
        Point point = BWTUtil.translateToParent(frame, this, n4, this.text.location().y + this.text.size().height);
        point = BWTUtil.translateToParent(null, frame, point.x, point.y);
        Dimension dimension = this.getToolkit().getScreenSize();
        if (!this.using_window) {
            dimension = frame.size();
        }
        point.x = Math.max(0, Math.min(point.x, dimension.width - n2));
        point.y = Math.max(0, Math.min(point.y, dimension.height - n3));
        if (!this.using_window) {
            this.list.reshape(point.x, point.y, n2, n3);
        } else {
            ((Component)this.list_window).reshape(point.x, point.y, n2, n3);
            this.list.resize(n2, n3);
            this.list.show();
            this.list_window.show();
        }
        this.list.exited = true;
        this.list.show();
        this.list.getList().requestFocus();
        this.list_poppedup = true;
    }

    void hideList() {
        JCComponent.popdown_time = System.currentTimeMillis();
        this.list_poppedup = false;
        if (this.style == 0) {
            return;
        }
        if (this.using_window && this.list_window != null) {
            ((Component)this.list_window).hide();
        } else if (!this.using_window) {
            this.list.hide();
        }
        this.text.requestFocus();
    }

    protected void setTextAction(String string) {
        JCComboBoxEvent jCComboBoxEvent = this.postComboBoxEvent(1, string);
        if (jCComboBoxEvent != null) {
            string = jCComboBoxEvent.value != null ? jCComboBoxEvent.value.toString() : null;
        }
        this.text.setText(string);
        this.hideList();
        if (this.itemListeners.size() == 0) {
            return;
        }
        JCItemEvent jCItemEvent = new JCItemEvent(this, 701, (Object)string, 1);
        int n = 0;
        while (n < this.itemListeners.size()) {
            JCItemListener jCItemListener = (JCItemListener)this.itemListeners.elementAt(n);
            jCItemListener.itemStateChanged(jCItemEvent);
            ++n;
        }
    }

    protected JCComboBoxEvent postComboBoxEvent(int n, Object object) {
        if (this.listeners.size() == 0) {
            return null;
        }
        JCComboBoxEvent jCComboBoxEvent = new JCComboBoxEvent((Object)this, object);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            JCComboBoxListener jCComboBoxListener = (JCComboBoxListener)this.listeners.elementAt(n2);
            if (n == 0) {
                jCComboBoxListener.comboBoxListDisplayBegin(jCComboBoxEvent);
            } else {
                jCComboBoxListener.comboBoxListDisplayEnd(jCComboBoxEvent);
            }
            ++n2;
        }
        return jCComboBoxEvent;
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.text && keyEvent.isControlDown() && keyEvent.getKeyCode() == 40) {
            this.showListAction(new JCActionEvent(this.text, keyEvent.getID(), null, keyEvent.getModifiers()));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.button) {
            long l = System.currentTimeMillis() - JCComponent.popdown_time;
            if (l >= 0L && l < 150L) {
                this.hideList();
                return;
            }
            this.showListAction(jCActionEvent);
            return;
        }
        if (jCActionEvent.getSource() == this.list) {
            this.setTextAction(this.getSelectedItem());
            return;
        }
        if (jCActionEvent.getSource() == this.text && this.actionListeners.size() > 0) {
            JCActionEvent jCActionEvent2 = new JCActionEvent(this, 1001, null);
            int n = 0;
            while (n < this.actionListeners.size()) {
                ((JCActionListener)this.actionListeners.elementAt(n)).actionPerformed(jCActionEvent2);
                ++n;
            }
        }
    }

    public void listItemSelectBegin(JCListEvent jCListEvent) {
    }

    public void listItemSelectEnd(JCListEvent jCListEvent) {
        if (jCListEvent.getStateChange() != 1) {
            return;
        }
        if (jCListEvent.event == null || jCListEvent.event.id == 501) {
            this.setTextAction(this.getSelectedItem());
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public void paintInterior(Graphics graphics) {
        if (this.style == 0) {
            return;
        }
        Color color = this.getBackground();
        Shadow.draw(graphics, 3, 1, 0, 0, this.size().width, this.size().height, color == Color.lightGray ? Color.white : BWTUtil.brighter(color), BWTUtil.darker(color), null);
        Shadow.draw(graphics, 3, 1, 1, 1, this.size().width - 2, this.size().height - 2, color.brighter().darker(), Color.black, null);
    }
}

